/*

Macro_Scripts File
Purposes:  
    
	define UI actions for the xView feature introduced in 3ds max 2010

Revision History
	July 2008: Pierre-Felix Breton
	created for 3ds MAX 2010
	July 2008: Michael Zyracki
	finished it

IDs for checkers.
Isolated Vertex 	1
Overlapping Faces 	2
Multiple Edges		3
Open Edges		4
Face Orientation	5
Missing UV Coordinates	6
Overlapping Vertices	7
T-Verts			8
Flipped UVW Faces	9
Overlapped UVW Faces	10

*/

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************


--***********************************************************************************************
-- Macros to enable each checker, to be hooked in the CUi system
--***********************************************************************************************

MacroScript xView_Isolated_Vertex_Checker
            ButtonText:~XVIEW_ISOLATED_VERTEX_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_ISOLATED_VERTEX_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 1
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapping_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPING_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 2
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Multiple_Edges_Checker
            ButtonText:~XVIEW_MULTIPLE_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MULTIPLE_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 3
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Open_Edges_Checker
            ButtonText:~XVIEW_OPEN_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OPEN_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 4
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Face_Orientation_Checker
            ButtonText:~XVIEW_FACE_ORIENTATION_CHECKER_BUTTONTEXT~
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FACE_ORIENTATION_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 5
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Missing_UV_Coordinates_Checker
            ButtonText:~XVIEW_MISSING_UV_COORDINATES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MISSING_UV_COORDINATES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 6
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Overlapping_Vertices_Checker
            ButtonText:~XVIEW_OVERLAPPING_VERTICES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_VERTICES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 7
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_TVerts_Checker
            ButtonText:~XVIEW_TVERTS_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_TVERTS_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 8
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Flipped_UVW_Faces_Checker
            ButtonText:~XVIEW_FLIPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FLIPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 9
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapped_UVW_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 10
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

--***********************************************************************************************
-- Macros to cycle through the list of checkers, useful when assigned to a hotkey
--***********************************************************************************************


MacroScript xView_Cycle_Forward
            ButtonText:~XVIEW_CYCLE_FORWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_FORWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex < xViewChecker.getNumCheckers()) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex + 1
				else xViewChecker.ActiveIndex = 1
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Cycle_Backward
            ButtonText:~XVIEW_CYCLE_BACKWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_BACKWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex > 1) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex - 1
				else xViewChecker.ActiveIndex = xViewChecker.getNumCheckers()
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript

--***********************************************************************************************
-- Misc Macros to perform different checker functions
--***********************************************************************************************

MacroScript xView_Select_Results
            ButtonText:~XVIEW_SELECT_RESULTS_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SELECT_RESULTS_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				xViewChecker.selectResults sliderTime
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_See_Through
            ButtonText:~XVIEW_SEE_THROUGH_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SEE_THROUGH_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.seeThrough) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.seeThrough==true) 
				then xViewChecker.seeThrough = false
				else xViewChecker.seeThrough = true
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Auto_Update
            ButtonText:~XVIEW_AUTO_UPDATE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_AUTO_UPDATE_TOOLTIP~ 
(
	on ischecked Return Try(xViewChecker.autoUpdate) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.autoUpdate==true) 
				then xViewChecker.autoupdate = false
				else xViewChecker.autoupdate = true
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Display_On_Top
            ButtonText:~XVIEW_DISPLAY_ON_TOP_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_DISPLAY_ON_TOP_TOOLTIP~ 
(
	on ischecked  Return Try(xViewChecker.displayTextUpTop) Catch()
	On Execute Do 
		Try (

			if (xViewChecker.displayTextUpTop==true) 
				then xViewChecker.displayTextUpTop = false
				else xViewChecker.displayTextUpTop= true
			
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Configure
            ButtonText:~XVIEW_CONFIGURE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CONFIGURE_TOOLTIP~ 
(
	on isenabled Return Try(xViewChecker.doesCheckerHavePropDlg xViewChecker.activeIndex == True) Catch()

	On Execute Do 
		Try (
				xViewChecker.showCheckerPropDlg xViewChecker.activeIndex
			)	
		Catch()	
	 
)--end MacroScript


